/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.api;

import filenet.sim.api.VWSIMSimulationXMLHandler;
import filenet.vw.api.VWException;
import filenet.vw.base.XMLHelper;
import filenet.vw.base.logging.Logger;

public class VWSIMXMLOptions {
    private String m_webApp = null;
    private String m_libraryId = null;
    private String m_docId = null;
    private String m_system = null;
    private int m_region = 1;
    private int m_simLifeSpan = 2;
    private String m_name = null;
    private String m_simUrl = null;
    private String m_serverUrl = null;
    private String m_serverDownloadUrl = null;
    private String m_serverUploadUrl = null;
    private String m_user = null;
    private String m_pw = null;
    private static Logger logger = Logger.getLogger("filenet.sim.api");
    private static final String m_className = "VWSIMXMLOptions";
    private String m_psServerUrl = null;

    private String getRealPsServer() {
        String m_method = "getRealPsServer:" + this.m_psServerUrl;
        String RMI_PROTOCOL = "rmi://";
        String res = null;
        try {
            int i;
            if (this.m_psServerUrl == null) {
                return null;
            }
            if (!this.m_psServerUrl.startsWith("rmi://")) {
                return null;
            }
            int j = i = "rmi://".length();
            while (this.m_psServerUrl.charAt(i) != '/') {
                ++i;
            }
            res = this.m_psServerUrl.substring(j, i);
            if (logger.isFinest()) {
                logger.finest(m_className, m_method, res);
            }
        }
        catch (Exception e) {
            logger.throwing(m_className, m_method, e);
        }
        return res;
    }

    private String adjustSimUrl(String simUrl) {
        if (simUrl != null && simUrl.endsWith("P8BPMWSBroker")) {
            simUrl = simUrl + "/";
        }
        return simUrl;
    }

    public VWSIMXMLOptions(String libraryId, String docId, String system, int region, String name, int simLifeSpan, String webApp, String simUrl, String serverUrl, String serverUploadUrl, String serverDownloadUrl, String user, String pw, String psServerUrl) {
        this.m_libraryId = libraryId;
        this.m_docId = docId;
        this.m_system = system;
        this.m_region = region;
        this.m_simLifeSpan = simLifeSpan;
        this.m_name = name;
        this.m_webApp = webApp;
        this.m_simUrl = this.adjustSimUrl(simUrl);
        this.m_serverUrl = serverUrl;
        this.m_serverUploadUrl = serverUploadUrl;
        this.m_serverDownloadUrl = serverDownloadUrl;
        this.m_user = user;
        this.m_pw = pw;
        this.m_psServerUrl = psServerUrl;
    }

    public VWSIMXMLOptions(String libraryId, String docId, String system, int region, String name, int simLifeSpan, String webApp, String simUrl) {
        this.m_libraryId = libraryId;
        this.m_docId = docId;
        this.m_system = system;
        this.m_region = region;
        this.m_simLifeSpan = simLifeSpan;
        this.m_name = name;
        this.m_webApp = webApp;
        this.m_simUrl = this.adjustSimUrl(simUrl);
    }

    public void toXML(StringBuffer theBuffer) throws VWException {
        String BASE_INDENT = "";
        String BUMP_INDENT = "\t";
        if (theBuffer == null) {
            throw new VWException("sim.appserver.VWSIMXMLOptions", "buffer parameter cannot be null.");
        }
        theBuffer.append("<options>");
        if (this.m_webApp != null) {
            theBuffer.append("<webApp value=\"").append(this.m_webApp).append("\"/>");
        }
        if (this.m_libraryId != null) {
            theBuffer.append("<docInfo library=\"").append(VWSIMXMLOptions.toXMLString(this.m_libraryId)).append("\"");
        }
        if (this.m_simUrl != null) {
            theBuffer.append(" simUrl=\"").append(VWSIMXMLOptions.toXMLString(this.m_simUrl)).append("\"");
        }
        if (this.m_docId != null) {
            theBuffer.append(" docId=\"").append(VWSIMXMLOptions.toXMLString(this.m_docId)).append("\"/>");
        }
        if (this.m_system != null) {
            theBuffer.append("<simulation system=\"").append(VWSIMXMLOptions.toXMLString(this.m_system)).append("\"");
        }
        if (this.m_name != null) {
            theBuffer.append(" name=\"").append(VWSIMXMLOptions.toXMLString(this.m_name)).append("\"");
        }
        theBuffer.append(" region=\"").append(this.m_region).append("\"/>");
        theBuffer.append("<lifespan value=\"").append(this.m_simLifeSpan).append("\"/>");
        if (this.m_user != null) {
            theBuffer.append("<user value=\"").append(VWSIMXMLOptions.toXMLString(this.m_user)).append("\"/>");
        }
        if (this.m_pw != null) {
            theBuffer.append("<pw value=\"").append(VWSIMXMLOptions.toXMLString(this.m_pw)).append("\"/>");
        }
        if (this.m_serverUrl != null) {
            theBuffer.append("<serverUrl value=\"").append(VWSIMXMLOptions.toXMLString(this.m_serverUrl)).append("\"/>");
        }
        if (this.m_serverUploadUrl != null) {
            theBuffer.append("<serverUploadUrl value=\"").append(VWSIMXMLOptions.toXMLString(this.m_serverUploadUrl)).append("\"/>");
        }
        if (this.m_serverDownloadUrl != null) {
            theBuffer.append("<serverDownloadUrl value=\"").append(VWSIMXMLOptions.toXMLString(this.m_serverDownloadUrl)).append("\"/>");
        }
        if (this.m_psServerUrl != null) {
            theBuffer.append("<psServerUrl value=\"").append(VWSIMXMLOptions.toXMLString(this.m_psServerUrl)).append("\"/>");
        }
        theBuffer.append("</options>");
    }

    public String getLibraryId() {
        return this.m_libraryId;
    }

    public String getDocId() {
        return this.m_docId;
    }

    public String getSystem() {
        return this.m_system;
    }

    public int getRegion() {
        return this.m_region;
    }

    public String getName() {
        return this.m_name;
    }

    public int getLifespan() {
        return this.m_simLifeSpan;
    }

    public String getWebApp() {
        return this.m_webApp;
    }

    public String getSimUrl() {
        return this.m_simUrl;
    }

    public String getServerUrl() {
        return this.m_serverUrl;
    }

    public String getServerUploadUrl() {
        return this.m_serverUploadUrl;
    }

    public String getServerDownloadUrl() {
        return this.m_serverDownloadUrl;
    }

    public String getPsServerUrl() {
        return this.getRealPsServer();
    }

    public String getUser() {
        return this.m_user;
    }

    public String getPw() {
        return this.m_pw;
    }

    public void setServerUrl(String serverUrl) {
        this.m_serverUrl = serverUrl;
    }

    public void setServerUploadUrl(String serverUploadUrl) {
        this.m_serverUploadUrl = serverUploadUrl;
    }

    public void setServerDownloadUrl(String serverDownloadUrl) {
        this.m_serverDownloadUrl = serverDownloadUrl;
    }

    public void setUser(String user) {
        this.m_user = user;
    }

    public void setPw(String pw) {
        this.m_pw = pw;
    }

    public void setPsServerUrl(String s) {
        this.m_psServerUrl = s;
    }

    static String toXMLString(String buf) {
        return XMLHelper.toXMLString(buf);
    }

    public static void main(String[] args) {
        try {
            VWSIMXMLOptions a = new VWSIMXMLOptions("1111", "dddd", "mysys", 1234, "mysimname", 24, "WORKPLACE", "http://localhost:8080/Workplace/vwsimsoapservlet");
            StringBuffer theBuffer = new StringBuffer();
            a.toXML(theBuffer);
            String s = new String(theBuffer);
            System.out.println(s);
            VWSIMXMLOptions b = null;
            b = VWSIMSimulationXMLHandler.parseXMLSimulationOptions(s);
            System.out.println(b.getDocId());
            System.out.println(b.getWebApp());
            b = new VWSIMXMLOptions("l", "d", "sys", 5234, "name", 12, "webApp", "simUrl", "serverUrl", "severUploadUrl", "serverDOwnloadUrl", "user", "pw", "host:port");
            String newUrl = "rmi://x.y:123/aloha";
            b.setPsServerUrl(newUrl);
            System.out.println("psserverUrl = " + b.getPsServerUrl() + "=??=" + newUrl);
            StringBuffer mybuf = new StringBuffer();
            b.toXML(mybuf);
            s = mybuf.toString();
            System.out.println("SECONdSTRING = " + s);
            b = VWSIMSimulationXMLHandler.parseXMLSimulationOptions(s);
            System.out.println("serverURL = " + b.getServerUrl());
            System.out.println("serverDownloadUrl = " + b.getServerDownloadUrl());
            System.out.println("serverUploadURL = " + b.getServerUploadUrl());
            System.out.println("user=" + b.getUser());
            System.out.println("pw=" + b.getPw());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String _get_FILE_DATE() {
        return "$Date:   29 Jun 2007 01:46:54  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   qdang  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.14  $";
    }
}

